# Secure Note Sharing

A secure, containerized application for sharing one-time readable notes.

## Features

- Create encrypted notes with one-time read access
- Share notes via unique URLs
- Notes are automatically deleted after reading
- Modern, responsive UI with theme support
- Containerized for easy deployment

## Tech Stack

- Frontend: React + TypeScript + Tailwind CSS
- Backend: Node.js + Express
- Database: SQLite
- Containerization: Docker

## Getting Started

1. Clone the repository
2. Make sure you have Docker and Docker Compose installed
3. Run the application:

```bash
docker-compose up --build
```

The application will be available at:
- Frontend: http://localhost:3000
- Backend API: http://localhost:5000

## How to Use

1. Write your note in the text area
2. Click "Create Note" to generate a shareable link
3. Share the link with someone
4. They can paste the link or note ID to read the note
5. Once read, the note is permanently deleted

## Security Features

- Notes are encrypted using AES encryption
- Each note has a unique encryption key
- Notes are deleted after being read
- No note content is stored in plaintext
